let w, h;
let activeKeys = [];

const userDraw = draw;
window.draw = function draw() {
  w = width / 100;
  h = height / 100;
  userDraw.call(this);
};

if (!setup) {
  function setup() {
    noLoop();
    createCanvas(windowWidth, windowHeight);
  }
}

if (!windowResized) {
  function windowResized() {
    resizeCanvas(windowWidth, windowHeight);
  }
}

const userKeyPressed = window.keyPressed ?? (() => {});
window.keyPressed = function keyPressed(ev) {
  activeKeys.push(key);

  console.log(key);
  

  if (activeKeys.includes("Control") || activeKeys.includes("Meta")) {
    switch (key) {
      case "c":
        background(255);
        break;
      case "l":
        ev.preventDefault();
        isLooping() ? noLoop() : loop();
        break;
      case " ":
        draw();
        if (activeKeys.includes("Shift")) {
          for (let i = 0; i < 4; i++) {
            draw();
          }
        }
        break;
    }
  }

  if (window.keyDown) {
    updateKeyDown();
  }

  userKeyPressed.call(this);
};

const userKeyReleased = window.keyReleased ?? (() => {});
window.keyReleased = function keyReleased() {
  activeKeys = activeKeys.filter((k) => k != key);
  userKeyReleased.call(this);
};

function updateKeyDown() {
  if (activeKeys.length > 0) {
    requestAnimationFrame(updateKeyDown);
  }

  keyDown();
}
